<?php 
require_once('../../config.php');
require_once("{$CFG->libdir}/completionlib.php");
require_once("{$CFG->libdir}/accesslib.php");

class edit_announcement extends table_sql {

    /**
     * Constructor
     * @param int $uniqueid all tables have to have a unique id, this is used
     *      as a key when storing table properties like sort order in the session.
     */
    function __construct($uniqueid) {
        parent::__construct($uniqueid);
        // Define the list of columns to show.
        $columns = array('num','name','announcement_type','announcement_date', 'action');
        $this->define_columns($columns);

        // Define the titles of columns to show in header.
        $headers = array('S No.','Name','Type', 'Announcement Date', 'Edit');
        $this->define_headers($headers);
    }

    function col_announcement_date($row){
        return date('d/M/Y',$row->announcement_date);
    }


    function col_action($row){
        $fielddelete = new moodle_url("/local/public/delete_announcement.php?fieldid=$row->id");
        $field_update = new moodle_url("/local/public/announcement.php?fieldid=$row->id");
        return html_writer::div("<a href='$fielddelete'><i class='fa fa-trash'  onClick=\"javascript:return confirm('are you sure you want to delete ?');\" ></i></a><br><a href='$field_update'><i class='fa fa-pencil'></i></a>", 'edit', array('id' => 'edit')); 
    }
}
?>