<?php

require_once('../../config.php');
require_once('lib.php');
require_once("$CFG->libdir/tablelib.php");
require "activeuser_tableform.php";
require_once(__DIR__ . "/activeuser_filter.php");
require_once($CFG->dirroot . '/user/lib.php');

global $DB, $USER, $OUTPUT, $PAGE;
require_login();

$PAGE->set_pagelayout('standard');
$PAGE->set_context(context_system::instance());
$PAGE->requires->css('/local/public/css/active_table.css');
$PAGE->requires->js('/local/public/amd/src/active_table.js');

$download     = optional_param('download', '', PARAM_ALPHA);
$suspend      = optional_param('suspend', 0, PARAM_INT);
$delete       = optional_param('delete', 0, PARAM_INT);
$unsuspend    = optional_param('unsuspend', 0, PARAM_INT);
$confirm      = optional_param('confirm', '', PARAM_ALPHANUM);  
$page      = optional_param('page', null, PARAM_INT);  


if (!is_siteadmin()) {
  if (!user_has_role_assignment($USER->id,1)) {
   throw new moodle_exception('you dont have permission to access this page','core');
  }
}
// $returnurl = new moodle_url('activeuser_table.php');

$returnurl = new moodle_url('activeuser_table.php', array('page' => $page));


$sitecontext = context_system::instance();
$site = get_site();

$users = $DB->count_records('user',['deleted'=>0,'suspended'=>0,'confirmed'=>1]);


// code for suspend the user
if ($suspend and confirm_sesskey()) {
  require_capability('moodle/user:update', $sitecontext);

  if ($user = $DB->get_record('user', array('id' => $suspend, 'mnethostid' => $CFG->mnet_localhost_id, 'deleted' => 0))) {
    if (!is_siteadmin($user) and $USER->id != $user->id and $user->suspended != 1) {
      $user->suspended = 1;
      // Force logout.
      \core\session\manager::kill_user_sessions($user->id);
      user_update_user($user, false);
    }
  }

  redirect($returnurl);
}

// code for unsuspend the user

if ($unsuspend and confirm_sesskey()) {
  require_capability('moodle/user:update', $sitecontext);

  if ($user = $DB->get_record('user', array('id' => $unsuspend, 'mnethostid' => $CFG->mnet_localhost_id, 'deleted' => 0))) {
    if ($user->suspended != 0) {
      $user->suspended = 0;
      user_update_user($user, false);
    }
  }
  redirect($returnurl);
}

// code for delte the user

if ($delete and confirm_sesskey()) {   // Delete a selected user, after confirmation
         
  require_capability('moodle/user:delete', $sitecontext);

  $user = $DB->get_record('user', array('id' => $delete, 'mnethostid' => $CFG->mnet_localhost_id), '*', MUST_EXIST);

  if ($user->deleted) {
  
    print_error('usernotdeleteddeleted', 'error');
  }
  if (is_siteadmin($user->id)) {
    print_error('useradminodelete', 'error');
  }

  if ($confirm != md5($delete)) {
    $PAGE->set_heading('Delete User');
    $PAGE->navbar->add('User Management', new moodle_url('/local/public/activeuser_table.php'));
    $PAGE->navbar->add('Delete User', '');
    echo $OUTPUT->header();
    $fullname = fullname($user, true);
    echo $OUTPUT->heading(get_string('deleteuser', 'admin'));

    $optionsyes = array('delete' => $delete, 'confirm' => md5($delete), 'sesskey' => sesskey());
    $deleteurl = new moodle_url($returnurl, $optionsyes);
    $deletebutton = new single_button($deleteurl, get_string('delete'), 'post');
   
    echo $OUTPUT->confirm(get_string('deletecheckfull', '', "'$fullname'"), $deletebutton, $returnurl);
    echo $OUTPUT->footer();
    die;
  } else if (data_submitted()) {

    if (delete_user($user)) {
      \core\session\manager::gc(); // Remove stale sessions.
      redirect($returnurl);
    } else {
      \core\session\manager::gc(); // Remove stale sessions.
      // echo $OUTPUT->header();
      echo $OUTPUT->notification($returnurl, get_string('deletednot', '', fullname($user, true)));
    }
  }
}

if (is_null($page)) {
  unset($_SESSION['status']);
  unset($_SESSION['search']);
}

$mform = new active_form();


if ($mform->is_cancelled()) {  // when form is cancel
  session_start();
  unset($_SESSION['status']);
  unset($_SESSION['search']);
  redirect(new moodle_url("/local/public/activeuser_table.php"));
} else if ($fromform = $mform->get_data()) {    // when form is submit

  $status = $fromform->status;
  $search_value = $fromform->search;
  $submit = $fromform->submitbutton;
}

if ($submit) {

  if ($_SESSION['status']) {    // unset session status
    unset($_SESSION['status']);
  }
  if ($_SESSION['search']) {    // unset session search
    unset($_SESSION['search']);
  }
  session_start();

if ($search_value) {
  $_SESSION['search'] = $fromform->search;
  if ($status) {

    if ($status == "active") {
      $_SESSION['status'] = $fromform->status;
    
      $where = 'u.id = uo.userid AND ( u.id LIKE "%'.$search_value.'%" OR u.firstname LIKE "%'.$search_value.'%" OR u.lastname LIKE "%'.$search_value.'%" OR  u.email LIKE "%'.$search_value.'%" OR  u.city LIKE "%'.$search_value.'%")   AND u.deleted = 0';

    } else if ($status == "inactive") {
      $_SESSION['status'] = $fromform->status;
      $where = 'NOT EXISTS
      (SELECT *  
         FROM  {user_online} uo
         WHERE uo.userid = u.id) AND (u.id LIKE "%'.$search_value.'%" OR u.firstname LIKE "%'.$search_value.'%" OR u.lastname LIKE "%'.$search_value.'%" OR u.email LIKE "%'.$search_value.'%" OR  u.city LIKE "%'.$search_value.'%") AND u.deleted = 0';
    }
  }
  else {
    $where = '(u.id LIKE "%'.$search_value.'%" OR u.firstname LIKE "%'.$search_value.'%" OR u.lastname LIKE "%'.$search_value.'%" OR u.email LIKE "%'.$search_value.'%" OR  u.city LIKE "%'.$search_value.'%") AND u.deleted = 0';
  }
  
}
else {
  if ($status == "active") {
    $_SESSION['status'] = $fromform->status;

    $where = 'u.id = uo.userid AND u.deleted = 0';
  } else if ($status == "inactive") {
    $_SESSION['status'] = $fromform->status;
    $where = "NOT EXISTS
    (SELECT *  
       FROM  {user_online} uo
       WHERE uo.userid = u.id) AND u.deleted = 0";
  } else {
    $where = 'u.deleted = 0';
  }
}

}

elseif ($_SESSION['status'] && $_SESSION['search']) {
 
  if ($_SESSION['status'] == 'active') {
    $where = 'u.id = uo.userid AND (u.id LIKE "%'.$_SESSION['search'].'%" OR u.firstname LIKE "%'.$_SESSION['search'].'%" OR u.lastname LIKE "%'.$_SESSION['search'].'%" OR u.email LIKE "%'.$_SESSION['search'].'%" OR  u.city LIKE "%'.$_SESSION['search'].'%") AND u.deleted = 0';
  } elseif ($_SESSION['status'] == 'inactive') {

    $where = 'NOT EXISTS
      (SELECT *  
         FROM  {user_online} uo
         WHERE uo.userid = u.id) AND (u.id LIKE "%'.$_SESSION['search'].'%" OR u.firstname LIKE "%'.$_SESSION['search'].'%" OR u.lastname LIKE "%'.$_SESSION['search'].'%" OR u.email LIKE "%'.$_SESSION['search'].'%" OR  u.city LIKE "%'.$_SESSION['search'].'%") AND u.deleted = 0';
  }
}
else {
  if ($_SESSION['status']) {
    if ($_SESSION['status'] == 'active') {
      $where = 'u.id = uo.userid AND u.deleted = 0';
    } elseif ($_SESSION['status'] == 'inactive') {
  
      $where = "NOT EXISTS
        (SELECT *  
           FROM  {user_online} uo
           WHERE uo.userid = u.id) AND u.deleted = 0";
    }
  } 
  elseif ($_SESSION['search']) {
    $where = '(u.id LIKE "%'.$_SESSION['search'].'%" OR u.firstname LIKE "%'.$_SESSION['search'].'%" OR u.lastname LIKE "%'.$_SESSION['search'].'%" OR u.email LIKE "%'.$_SESSION['search'].'%" OR  u.city LIKE "%'.$_SESSION['search'].'%") AND u.deleted = 0';
  
  }
  else {
    $where = 'u.deleted = 0';
  }
  
}

$fields = 'u.id,u.firstname,u.email,u.city,u.country,uo.status,u.lastname,u.lastaccess,u.suspended';
$from = '{user} u LEFT JOIN {user_online} uo ON uo.userid = u.id ';

//  download columne remove action whene download action
$not_download="";
if($download){
$not_download="not";
}

$table = new active_tableuser('uniqueid',$not_download);
$table->is_downloading($download, 'report','testing123');

if (!$table->is_downloading()) {  
 

  $title = ' Users Management';
  $PAGE->set_title($title);
  $PAGE->set_heading($title);
  $PAGE->navbar->add('Users Management', new moodle_url(''));

  echo $OUTPUT->header();
  echo $OUTPUT->heading($users.' Users');

  $mform->display();
}


$table->define_baseurl("$CFG->wwwroot/local/public/activeuser_table.php?page=0");
$table->set_sql($fields, $from, $where);
$table->print_html(); 
$table->out(10,true);

if (!$table->is_downloading()) {
  echo $OUTPUT->footer();
}
