<?php
require_once('../../config.php');
require_once('lib.php');

require_once("$CFG->libdir/formslib.php");
global $DB,$USER, $OUTPUT, $PAGE;

class editbadges extends moodleform {
    
    //Add elements to form
    public function definition() {
        global $CFG;
        $btnstring = 'Save';
        $mform = $this->_form; // Don't forget the underscore! 
        $page = $this->_customdata['page'];

        $mform->addElement('header', 'editbadges', 'Edit Badges');
        
        $mform->addElement('hidden', 'selectedid', 0);
		$mform->setType('selectedid', PARAM_NOTAGS); 

        $mform->addElement('hidden', 'page', $page);
		$mform->setType('page', PARAM_NOTAGS); 

        $mform->addElement('text', 'badgename', 'Name of badge'); 
        $mform->addRule('badgename','* this field is required', 'required'); // Add elements to your form.
        $mform->setType('badgename', PARAM_NOTAGS);                   // Set type of element.
        $accept_types = ['.png','.jpg'];

   
        $mform->addElement('filepicker', 'userfile','Image', null, array('accepted_types' => $accept_types));

        $mform->addElement('text', 'filename', 'File name','readonly'); 
        $mform->setType('filename', PARAM_TEXT);
        // $mform->setAdvanced('filename', array('disabled' => 'disabled'));
     
        // $mform->addRule('userfile','* this field is required', 'required');   // Add elements to your form.

        $this->add_action_buttons(true, $btnstring);
    }
    //Custom validation should be added here
    function validation($data, $files) {
        global $DB;
        $errors= array();
        $table = 'custom_badge';
        $record=$DB->get_record($table, array('badge_name'=>$data['badgename']));
        
        if ($DB->record_exists($table, array('badge_name' => $data['badgename']))) {
            if ($record->id != $data['selectedid']) {
                $errors['badgename'] = 'Badge name already exist';
                return $errors;
            }
        }

        
    }
}


?>