<?php
require_once('../../config.php');
global $trackid, $USER, $instructor_condition;
require_login();
$trackid = required_param('id', PARAM_INT);

$title = 'My Courses';
$pagetitle = $title;
$PAGE->set_title($title);
$PAGE->set_heading($title);
$PAGE->set_pagelayout('standard');
$PAGE->requires->css('/local/public/css/courses.css');
$PAGE->requires->css('/local/public/css/bootstrap.min.css');
$PAGE->requires->css('/local/public/css/font-awesome.min.css');
$PAGE->requires->js('/local/public/amd/src/view-courses.js');

$instructor_condition = false;

echo $OUTPUT->header();
$admin = get_admin();

$instructor_roleid = $DB->get_field('role', 'id', ['shortname' => 'manager']);
$create_course_permission = true;
if (!is_siteadmin()) {
   if (!user_has_role_assignment($USER->id, $instructor_roleid)) {
      throw new moodle_exception('You are not allowed to access this page', 'core');
   }

   if (user_has_role_assignment($USER->id, $instructor_roleid)) {
      $instructor_condition = true;
      // get courses data
      $coursesdata = $DB->get_records_sql("SELECT * FROM {course_categories} WHERE (usercreated = $USER->id OR usercreated = $admin->id OR visible = 1) AND parent =$trackid  ORDER BY id DESC");

      if (!$DB->record_exists('course_categories', ['id' => $trackid, 'usercreated' => $USER->id])) {
         $create_course_permission = false;
      }
   }
} else {

   $coursesdata = $DB->get_records('course_categories', ['parent' => $trackid], 'id desc', $fields = '*', $limitfrom = 0, $limitnum = 0);
   if (!$DB->record_exists('course_categories', ['id' => $trackid, 'usercreated' => $USER->id])) {
      $create_course_permission = false;
   }
}

foreach ($coursesdata as $datavalue) {
   $ready_for_publish = '';
   $class = '';
   $disable_approval = false;
   $request_pending = false;
   $status = '';
   $request_status = '';
   $requested_button = false;
   $send_for_approval = false;
   $revise = false;
   $approved_decline = false;
   $revise_approved_decline = false;
   $only_approved_condition = false;
   $only_rejected_condition = false;
   $edit_permission = false;
   // for edit and delete permission
   if ($DB->record_exists('course_categories',['id'=>$datavalue->id,'usercreated'=>$USER->id])) {
      $edit_permission = true;
   }
   
   // code for if user is admin
   if (!$instructor_condition) {
      if (!$DB->record_exists('course_categories', ['usercreated' => $USER->id, 'id' => $datavalue->id])) {   // if course is not created by admin
         if ($datavalue->visible == "1") {     // check if course is published
            $status = 'Published';
         }
         else {
            if ($DB->record_exists('request_subcategory', ['subcategory_id' => $datavalue->id])) {  // if course have some status
   
               $button_visible = false;
               if ($datavalue->visible == "1") {     // check if course is published
                  $status = 'Published';
               } else {
   
                  if ($DB->record_exists('request_subcategory', ['subcategory_id' => $datavalue->id, 'status' => 0])) {  // check if teacher sent course to admin
                     $status = '';
                     $get_approved_modules = $DB->count_records_sql("SELECT COUNT(rc.id) FROM {reject_course} rc WHERE rc.course_id IN (SELECT id FROM {course} WHERE category = $datavalue->id) AND rc.status = 4");
                     $get_modules_in_course = $DB->count_records_sql("SELECT COUNT(c.id) FROM {course} c WHERE c.category = $datavalue->id AND c.visible = 0");
                     $get_rejected_modules = $DB->count_records_sql("SELECT COUNT(rc.id) FROM {reject_course} rc WHERE rc.course_id IN (SELECT id FROM {course} WHERE category = $datavalue->id) AND rc.status = 0");
                   
                     if ($get_modules_in_course == $get_approved_modules) {
                        $only_approved_condition = true;
                     }
                     elseif ($get_rejected_modules == $get_modules_in_course) {
                        $only_rejected_condition = true;
                     }
                     else {
                     
                        if ($DB->record_exists_sql("SELECT * FROM {reject_course} WHERE course_id IN (SELECT id FROM {course} WHERE category = $datavalue->id) AND status IN (0,3)")) {
                           $approved_decline = true;
                        } else {
                           $request_pending = true;
                        }
                     }
                  }
                  if ($DB->record_exists('request_subcategory', ['subcategory_id' => $datavalue->id, 'status' => 4])) { // check if  course is revise
   
   
                     if ($DB->record_exists_sql("SELECT * FROM {reject_course} WHERE course_id IN (SELECT id FROM {course} WHERE category = $datavalue->id) AND status IN (0,3)")) {
                        $revise_approved_decline = true;
                     } else {
                        $revise = true;
                     }
                  }
                  if ($DB->record_exists('request_subcategory', ['subcategory_id' => $datavalue->id, 'status' => 5])) { // check if  course is rejected
                     $status = 'Rejected';
                     $class = 'rejected';
                  }
                  if ($DB->record_exists('request_subcategory', ['subcategory_id' => $datavalue->id, 'status' => 6])) {  // check if  course is approved
                     $status = 'Approved';
                     $class = 'approved';

                  }
               }
            }
            // if course is not sent then it should not be visible on playground page
            else {
               continue;
            }
         }
      }

      // if course is made by admin
      else {
         if ($datavalue->visible == 1) {     // check if course is published
            $status = 'Published';
         }

         if ($DB->record_exists('request_subcategory', ['subcategory_id' => $datavalue->id, 'status' => 6])) {   // check if course is approved
            if ($DB->record_exists('course', ['category' => $datavalue->id])) {
               # code...
               $request_status = 'Approved';
               $class = 'approved';
               $ready_for_publish = 'Publish';
            }
         }
      }
   }
   // end 

   // code for if user is instructor

   else {
      if (!$DB->record_exists('course_categories', ['usercreated' => $USER->id, 'id' => $datavalue->id])) {  // if course is not created by instructor
         if ($datavalue->visible == "1") {     // check if course is published
            $request_status = 'Published';
         }
         if ($DB->record_exists('course_categories', ['id' => $datavalue->id, 'visible' => 0])) {
            continue;
         }
      } else {   // if course is created by instructor
         if ($datavalue->visible == "1") {     // check if course is published
            $request_status = 'Published';
          
         } else {
            if ($DB->record_exists('course', ['category' => $datavalue->id])) {   // check if course has modules 
               if ($DB->record_exists('request_subcategory', ['subcategory_id' => $datavalue->id, 'status' => 0])) { // check after course is sent to admin
                  $request_status = 'Pending for Approval';
                  $class = 'pendingforapproval';
               } elseif ($DB->record_exists('request_subcategory', ['subcategory_id' => $datavalue->id, 'status' => 4])) {  // check if course is revised
                  $request_status = 'To be Revised';
                  $send_for_approval = true;
               } elseif ($DB->record_exists('request_subcategory', ['subcategory_id' => $datavalue->id, 'status' => 5])) {  // check if course is rejected
                  $request_status = 'Rejected';
                  $class = 'rejected';

               } elseif ($DB->record_exists('request_subcategory', ['subcategory_id' => $datavalue->id, 'status' => 6])) {   // check if course is approved

                  $request_status = 'Approved';
                  $class = 'approved';

                  $ready_for_publish = 'Publish';
               } else {
                  $send_for_approval = true;
               }
            } else {
               if ($DB->record_exists('course_categories', ['usercreated' => $USER->id, 'id' => $datavalue->id])) {

                  $disable_approval = true;
               }
            }
         }
      }
   }
   // end code for if user is instructor

   $context = context_coursecat::instance($datavalue->id);
   $test = file_rewrite_pluginfile_urls($datavalue->description, 'pluginfile.php', $context->id, 'coursecat', 'description', null);
   $modules_name =  $DB->get_records('course', ['category' => $datavalue->id]);
   if ($test) {
      $test = $test;
   } else {
      $test = '<img class="card-img-top" src="image/courses.jpg" alt="Card image">';
   }

   $track_name[] = ['coursename' => $datavalue->name, 'courseimage' => $test, 'submodulecount' => count($modules_name), 'starttext' => substr($datavalue->text, 0, 50), 'endtext' => substr($datavalue->text, 50, strlen($datavalue->text)), 'courseid' => $datavalue->id, 'trackid' => $trackid, 'status' => $status, 'requestbutton' => $send_for_approval, 'request_status' => $request_status, 'requestpending' => $request_pending, 'revise' => $revise, 'disable_approval' => $disable_approval, 'ready_for_publish' => $ready_for_publish, 'approved_decline' => $approved_decline, 'revise_approved_decline' => $revise_approved_decline,'only_approved_condition'=>$only_approved_condition,'only_rejected_condition'=>$only_rejected_condition,'edit_permission'=>$edit_permission,'class'=>$class];
}

$data = [
   'trackname' => $track_name,
   'trackid' => $trackid,
   'create_course_permission' => $create_course_permission

];
echo $OUTPUT->render_from_template('local_public/course', $data);
echo $OUTPUT->footer();
