<?php
require_once('../../config.php');
require_once(__DIR__ . '/lib.php');

require_login();

global $CFG, $USER,$PAGE;
$PAGE->set_heading('All Login Activity');
$PAGE->set_title('All Login Activity');
$PAGE->set_pagelayout('standard');
$PAGE->requires->css('/local/public/css/dashboard.css'); 
$PAGE->requires->css('/local/public/css/bootstrap.min.css'); 
$PAGE->requires->css('/local/public/css/font-awesome.min.css'); 
$PAGE->requires->css('/local/public/css/style.css'); 
$PAGE->requires->js('/local/public/amd/src/dashboard.js');
$PAGE->requires->js('/local/public/amd/src/bootstrap.min.js');


// get access data
$accessdata = $DB->get_records_sql("SELECT lsl.* FROM {logstore_standard_log} lsl WHERE lsl.userid = $USER->id AND lsl.action = 'loggedin' ORDER BY lsl.id DESC LIMIT 10");

$instructor_roleid = $DB->get_field('role','id',['shortname'=>'manager']);
$PAGE->navbar->add('All Login Activity', new moodle_url(''));
echo $OUTPUT->header();
$clearfilter = html_writer::link(new moodle_url('/local/public/alllogin_activity.php'), 'Clear filter', ['class' => 'btn btn-primary']);
// $bulkinactive = html_writer::link(new moodle_url('/local/public/alllogin_activity.php'), 'Bulk Logout', ['class' => 'btn btn-primary']);
$rowcount = 1;
foreach ($accessdata as $accessdata_value) {
  
   $user_ip = $accessdata_value->ip;
   $json     = file_get_contents("http://ipinfo.io/$user_ip/geo");
   $json     = json_decode($json, true);
   $city     = $json['city'];
   
   if ($accessdata_value->browsername == "Chrome") {
      $filename = "chrome";
   }
   if ($accessdata_value->browsername == "Firefox") {
      $filename = "firefox";
   }
   if ($accessdata_value->browsername == "Edge") {
      $filename = "microsoft";
   }
   if ($accessdata_value->browsername == "Compass") {
      $filename = "compass";
   }
   if ($accessdata_value->browsername) { 
      $browsername = $accessdata_value->browsername;
   }
   else {
      $browsername = '';
   }

   if ($DB->record_exists('sessions', ['userid' => $USER->id, 'timecreated' => $accessdata_value->timecreated, 'firstip' => $accessdata_value->ip])) {
      $active = 'active';
   }
   else {
      $active = '';

   }
  

   $login_data[] = [
      'rowcount' =>$rowcount,
      'date'=>date('d-m-Y h:i:s A', $accessdata_value->timecreated),
      'city'=>$city,
      'userip'=>$user_ip,
      'filename'=>$filename,
      'browsername'=>$browsername,
      'active'=> $active,
      'timecreated'=>$accessdata_value->timecreated,
      'accessip'=>$accessdata_value->ip,
      

   ];
   $rowcount++;
}
$data = [
'logindata'=>$login_data,
'clearfilter'=>$clearfilter,
// 'bulkinactive'=>$bulkinactive
];
echo $OUTPUT->render_from_template('local_public/alllogin_activity',$data); 
echo $OUTPUT->footer();
?>

