<?php

function local_public_extend_navigation(global_navigation $navigation)
{

    global $CFG, $DB, $USER, $PAGE, $playground_pic;
    $manager_roleid = $DB->get_field('role', 'id', ['shortname' => "manager"]);
    $cris_icon = new pix_icon('crisis', '', 'local_public', array('class' => 'icon pluginicon ', 'style' => 'width: 22px; height: 30px; object-fit: contain;'));
    $cyberrange = new pix_icon('cyberrange', '', 'local_public', array('class' => 'icon pluginicon ', 'style' => 'width: 22px; height: 30px; object-fit: contain;'));
    $icon3 = new pix_icon('report-icon', '', 'local_public', array('class' => 'icon pluginicon', 'style' => 'width: 22px; height: 30px; object-fit: contain;'));


    if (is_siteadmin() || user_has_role_assignment($USER->id, $manager_roleid)) {

        $icon = new pix_icon('playground', '', 'local_public', array('class' => 'icon pluginicon ', 'style' => 'width: 22px; height: 30px; object-fit: contain;'));

        $main_node = $PAGE->navigation->find('myprofile', navigation_node::TYPE_ROOTNODE);
        $main_node->nodetype = 1;
        $main_node->collapse = false;


        $navigation->add(
            'playground',
            new moodle_url($CFG->wwwroot . '/local/public/view-courses.php'),
            navigation_node::TYPE_CUSTOM,
            null,
            'local_public',
            $icon
        )->showinflatnavigation = true;
    }
    else {
        $icon = new pix_icon('playground', '', 'local_report', array('class' => 'icon pluginicon', 'style' => 'width: 22px; height: 30px; object-fit: contain;'));
        $navigation->add(
            'Playground',
            new moodle_url($CFG->wwwroot . '/local/report/index.php'),
            navigation_node::TYPE_CUSTOM,
            null,
            'report',
            $icon
        )->showinflatnavigation = true;
    }

    if (user_has_role_assignment($USER->id, 5)) {

        $icon = new pix_icon('playground', '', 'local_report', array('class' => 'icon pluginicon', 'style' => 'width: 22px; height: 30px; object-fit: contain;'));

        $main_node = $PAGE->navigation->find('myprofile', navigation_node::TYPE_ROOTNODE);
        $main_node->nodetype = 1;
        $main_node->collapse = false;


      
    }
    if (user_has_role_assignment($USER->id, 5) || user_has_role_assignment($USER->id, $manager_roleid) || is_siteadmin()) {
        $navigation->add(
            'Crisis Simulation',
            new moodle_url(''),
            navigation_node::TYPE_CUSTOM,
            null,
            'local_public',
            $cris_icon
        )->showinflatnavigation = true;

        $navigation->add(
            'Cyber Range',
            new moodle_url(''),
            navigation_node::TYPE_CUSTOM,
            null,
            'local_public',
            $cyberrange
        )->showinflatnavigation = true;

        $navigation->add(
            'Reports',
            new moodle_url($CFG->wwwroot . '/local/public/user_table.php'),
            navigation_node::TYPE_CUSTOM,
            null,
            'local_public',
            $icon3
        )->showinflatnavigation = true;
    }
}

function get_browser_name($user_agent)
{
    if (strpos($user_agent, 'Opera') || strpos($user_agent, 'OPR/')) return 'Opera';
    elseif (strpos($user_agent, 'Edg')) return 'Edge';
    elseif (strpos($user_agent, 'Chrome')) return 'Chrome';
    elseif (strpos($user_agent, 'Safari')) return 'Safari';
    elseif (strpos($user_agent, 'Firefox')) return 'Firefox';
    elseif (strpos($user_agent, 'MSIE') || strpos($user_agent, 'Trident/7')) return 'Internet Explorer';

    return 'Other';
}

function force_echo($value)
{
    echo "<pre>";
    var_dump($value);
    echo "</pre>";
    die;
}

function latest_announcement()
{
    global $DB, $USER;
    $today_date_timestamp = strtotime(date('Y-m-d', time()));
    $latest_announcement = '';
    $announcement = $DB->get_records('custom_announcement', ['announcement_date' => $today_date_timestamp]);
    $themecolor = $DB->get_record('navbar_color', ['userid' => $USER->id]);

    if ($themecolor->color_mode) {
        $color = 'white';
    } else {
        $color = 'black';
    }
    foreach ($announcement as $announcement_value) {

        if ($announcement_value->announcement_type == 'normal') {
            $latest_announcement .= '<p class="normal">' . $announcement_value->description . '</p>';
        } else {
            $latest_announcement .= '<p class="important"><i class="fa fa-flag" aria-hidden="true"></i>&nbsp;' . $announcement_value->description . '</p>';
        }
        if ($latest_announcement == '') {
            $latest_announcement = 'No Announcement';
        }
    }

    return $latest_announcement;
}
//for beadcrumb

function local_public_before_footer()
{

    global $DB, $USER;
    if (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on')
        $currenturl = "https://";
    else
        $currenturl = "http://";
    // Append the host(domain name, ip) to the URL.   
    $currenturl .= $_SERVER['HTTP_HOST'];

    // Append the requested resource location to the URL   
    $currenturl .= $_SERVER['REQUEST_URI'];
    $substring= '/mod/';
   $is_contain =  strpos($currenturl, $substring);

    if ($is_contain) {
        $student_roleid = $DB->get_field('role', 'id', ['shortname' => 'student']);
        if (user_has_role_assignment($USER->id, $student_roleid)) {
    
            $track = new moodle_url('/local/report/index.php');
        } else {
            $track = new moodle_url('/local/public/view-courses.php');
        }
        $my = new moodle_url('/my');
    
        $url_course_mod = new moodle_url('/mod/');
    
        $topic = '';
        $trackurl = '';
        $courseurl = '';
        $previous_url = '';
      
        if ($_SESSION['trackurl']) {
    
            $trackurl = $_SESSION['trackurl'];
        }
    
        if ($_SESSION['courseurl']) {
    
            $courseurl = $_SESSION['courseurl'];
        }
        if ($_SESSION['previous_url']) {
    
            $previous_url = $_SESSION['previous_url'];
        }
    
        // $courseurl = $_SESSION['courseurl'];
        // $previous_url = $_SESSION['previous_url'];
    
        if ($_SESSION['topics_url']) {
            $topic = $_SESSION['topics_url'];
        }
    
        $breadcrumbs = "<nav aria-label='Navigation bar'><ol class='breadcrumb'><li class='breadcrumb-item'><a href='$my'>Dashboard</a></li><li class='breadcrumb-item'><a href='$track'>Tracks</a></li><li class='breadcrumb-item'><a href='$courseurl'>Course</a></li><li class='breadcrumb-item'><a href='$previous_url'>Module</a></li><li class='breadcrumb-item'><a href='$topic'>Topics</a></li></ol></nav>";
        return '<script>
       var url = window.location.href
         if(url.includes("' . $url_course_mod . '")){
           $(document).ready(function(){
               $("#page-navbar").html("");
               $("#page-navbar").html("' . $breadcrumbs . '");
                 
           }); 
         }
        
    </script>';
    }
}
