<?php
require_once('../../config.php');
require_once(__DIR__ . '/lib.php');

require_login();
global $CFG, $USER, $PAGE;
$PAGE->set_heading('Instructor Dashboard');
$PAGE->set_title('Instructor Dashboard');
$PAGE->set_pagelayout('standard');
$PAGE->requires->css('/local/public/css/instructor.css');
$PAGE->requires->css('/local/public/css/bootstrap.min.css');
$PAGE->requires->css('/local/public/css/font-awesome.min.css');
$PAGE->requires->css('/local/public/css/style.css');
$PAGE->requires->css('/local/public/bootstrap/bootstrap-multiselect.css');
$PAGE->requires->css('/local/public/css/datepicker.min.css');
$PAGE->requires->js('/local/public/amd/src/instructor.js');
$PAGE->requires->js('/local/public/amd/src/bootstrap.min.js');
$PAGE->requires->js('/local/public/amd/src/bootstrap-multiselect.js');

$instructor_roleid = $DB->get_field('role', 'id', ['shortname' => 'manager']); // instructor role id
if (!user_has_role_assignment($USER->id, $instructor_roleid)) {
   redirect(new moodle_url('/my/'));
}

// ******* code for browser name *********
purge_caches();
$table = 'logstore_standard_log';
$lastlogin_record = $DB->get_record_sql("SELECT lsl.* FROM {logstore_standard_log} lsl WHERE lsl.userid = $USER->id AND lsl.action = 'loggedin' ORDER BY lsl.id DESC LIMIT 1");
if (!$lastlogin_record->browswername) {
   $dataobject = new stdClass();
   $dataobject->id = $lastlogin_record->id;
   $dataobject->browsername = get_browser_name($_SERVER['HTTP_USER_AGENT']);
   $namebrowser =  get_browser_name($_SERVER['HTTP_USER_AGENT']);

   $updated = $DB->execute("UPDATE {logstore_standard_log} SET browsername = '$namebrowser' WHERE id = $lastlogin_record->id");
}
// ******* end code for browser name *********

// ******* code for inacive and active user
$users = $DB->get_records('user', ['deleted' => 0]);
// $activeuser = $DB->get_records('user_online', array());
$activeuser = $DB->get_records_sql("SELECT u.* FROM {user_online} u JOIN {user} us ON us.id = u.userid WHERE us.deleted = 0");
$total_user = count($users);
$active_user = count($activeuser);
$inactive_user = $total_user - $active_user;
// ******* end code for inacive and active user

// ******* code for stay toggle theme change color .
$color = $DB->get_record('navbar_color', ['userid' => $USER->id]);
if (!$color->color_mode) {
   $addclass = "fa-toggle-on";
} else {
   $addclass = "";
}

// ******* end code for stay toggle theme change color 
$toptracks = $DB->get_records('course_categories', ['parent' => 0,'visible'=>1], $sort = '', $fields = '*', $limitfrom = 0, $limitnum = 5);
$alltracks = $DB->get_records('course_categories', ['parent' => 0,'visible'=>1], $sort = '', $fields = '*', $limitfrom = 0, $limitnum = 0);
$colorarray = ['#43C822', '#D93333', '#004CFD', '#EF9001', '#05E0FF'];
$recent_badge_assigned = $DB->get_records_sql("SELECT * FROM {assign_badge} bi  ORDER BY bi.id DESC LIMIT 5");
// $recent_certificate_assigned = $DB->get_records_sql("SELECT * FROM {assign_certificate} bi  ORDER BY bi.id DESC LIMIT 2");
$notepaddata = $DB->get_records_sql("SELECT * FROM {notepad} WHERE userid = $USER->id  ORDER BY id DESC limit 2");
$accessdata = $DB->get_records_sql("SELECT lsl.* FROM {logstore_standard_log} lsl WHERE lsl.userid = $USER->id AND lsl.action = 'loggedin' ORDER BY lsl.id DESC LIMIT 4");
// $draftmodules = $DB->get_records('course', ['usercreated' => $USER->id]);
$draftedcourses = $DB->get_records_sql("SELECT cc.* FROM {course_categories} cc JOIN {request_subcategory} rs ON rs.subcategory_id = cc.id  WHERE cc.visible = 0 AND (rs.status = 0 OR rs.status = 4 OR rs.status = 5 OR rs.status = 6) AND rs.userid = $USER->id ORDER BY cc.id DESC LIMIT 5");

?>
<!DOCTYPE html>
<html lang="en">

<head>
   <meta charset="UTF-8">
   <meta http-equiv="X-UA-Compatible" content="IE=edge">
   <meta name="viewport" content="width=device-width, initial-scale=1.0">
   <link rel="icon" href="<?php echo $CFG->wwwroot; ?>/theme/classic/pix/favicon.ico">
   <title>Instructor Dashboard</title>

</head>

<body>
   <?php echo $OUTPUT->header(); ?>
   <!-- <input type="hidden" id="toggleclass" value="<?php echo $addclass; ?>"> -->


   <div class="dashboard-main">
      <div class="container-fluid p-0">
         <div class="row">

            <div class="col-12 col-md-12 col-lg-12">
               <div class="right-content">


                  <div class="latest-announcement bg-grey">
                     <div class="latest-announcement-content">
                        <h2>Latest Announcement</h2>
                     </div>
                     <div class="marque">
                        <marquee behavior="" direction="">
                           <div style="display: flex;">
                              <?php echo latest_announcement(); ?>
                           </div>
                        </marquee>
                     </div>
                  </div>
                  <section class="swift-management bg-grey-box">


                     <h2 class="horizontal-line">swift management</h2>
                     <div class="management-section">
                        <div class="management user-button">
                           <div class="user-icon blue-bg"><img src="<?php echo $CFG->wwwroot.'/pix/UserManagement.svg' ?>" alt="UserManagement"></div>
                           <div class="user-detail">
                              <a href="activeuser_table.php">
                                 <h2 class="swift-management-h2">Users
                                    <br>
                                    <span class="active-green-pin"><?php echo $active_user . "/" . $inactive_user; ?></span>

                                 </h2>
                              </a>
                           </div>
                        </div>
                        <div class="management Content-button">
                           <div class="user-icon grey-bg"><img src="<?php echo $CFG->wwwroot.'/pix/Create-Content.svg'; ?>" alt="Create-Content"></div>
                           <div class="user-detail">
                              <a href="view-courses.php">
                                 <h2 class="swift-management-h2">Create
                                    <br>
                                    content
                                 </h2>
                              </a>
                           </div>
                        </div>
                        <div class="management Crisis-button">
                           <div class="user-icon purple-bg"><i class="fa fa-line-chart"></i></div>
                           <div class="user-detail">
                              <a href="#">
                                 <h2 class="swift-management-h2">Create
                                    <br>
                                    Crisis Exercise
                                 </h2>
                              </a>
                           </div>
                        </div>
                        <div class="management Simulation-button">
                           <div class="user-icon blue-bg-down"><img src="<?php echo $CFG->wwwroot.'/pix/Create-Content.svg'; ?>" alt="Create-Content"></div>
                           <div class="user-detail">
                              <a href="#">
                                 <h2 class="swift-management-h2">Create
                                    <br>
                                    scenario
                                 </h2>
                              </a>
                           </div>
                        </div>
                        <div class="management Announcement-Button">
                           <div class="user-icon blue-bg-dark"><img src="<?php echo $CFG->wwwroot.'/pix/Announcement.svg' ?>" alt="Announcement"></div>
                           <div class="user-detail">
                              <a href="edit_announcements.php">
                                 <h2  class="swift-management-h2 announcement">Announcement</h2>
                              </a>
                           </div>
                        </div>
                     </div>
                  </section>
                  <section class="section-status">
                     <div class="d-flex gap-4">
                        <div class="chart-section bg-grey-box">
                           <div class="status">
                              <div class="status-info">
                                 <h2 class="horizontal-line line1">Cyber Exercise Status</h2>
                                 <span><a href="#"><i class="fa fa-share-square-o" title="view all"></i></a></span>
                              </div>
                              <ul>
                                 <li class="list">1</li>
                                 <li class="list">2</li>
                                 <li class="list">3</li>
                                 <li class="list">4</li>
                                 <li class="list">5</li>
                                 <li class="list">6</li>
                              </ul>
                           </div>
                        </div>
                        <div class="chart-section bg-grey-box">
                           <div class="status">
                              <div class="status-info pb-1">
                                 <h2 class="horizontal-line line2">Quick Analysis</h2>
                                 <!-- <a href="view_tracks.php">
                                    <h2>View All</h2>
                                 </a> -->
                                 <span><a href="view_tracks.php?treset=1"><i class="fa fa-share-square-o" title="view all"></i></a></span>
                              </div>
                              <section class="chart">
                                 <canvas id="myChart" style="width:100%;max-width:13vw;"></canvas>
                                 <div class="track-table activity-overflow Quick-AnalysisQuick-Analysis">
                                    <select multiple="multiple" name="selecttrack" id="selecttrack" onchange="quickanalyis_record()">
                                       <div class="scrollit">
                                          <?php
                                          $z = 0;
                                          foreach ($alltracks as $alltracks_values) {

                                          ?>
                                             <option value="<?php echo $alltracks_values->id; ?>"><?php echo $alltracks_values->name; ?></option>

                                          <?php
                                             $z++;
                                          }
                                          ?>
                                       </div>
                                    </select>

                                    <div class="scrollit">
                                       <table>
                                          <thead>
                                             <tr>

                                                <th>
                                                   <!-- Tracks -->
                                                </th>
                                                <th>Courses</th>
                                                <th>Users</th>

                                             </tr>
                                          </thead>
                                          <tbody id="quick_analysis">
                                             <?php
                                             $y = 0;
                                             foreach ($toptracks as $alltracks_values) {

                                                $countcourse = $DB->get_records('course_categories', ['parent' => $alltracks_values->id]);
                                                $userids = [];
                                                foreach ($countcourse as $courses1) {
                                                   //    $cat = core_course_category::get($courses1->id);
                                                   //    $moduleids = $cat->get_courses(['recursive', 'idonly']);
                                                   $moduleids = $DB->get_records('course', ['category' => $courses1->id]);
                                                   foreach ($moduleids as $moduleid) {
                                                      $context = context_course::instance($moduleid->id);
                                                      $moduleusers = get_enrolled_users($context, '', 0, 'u.id');
                                                      $userids = array_merge($userids, array_keys($moduleusers));
                                                   }
                                                }
                                                $count_of_category_enrolled_user = count($userids);
                                                $count_of_user[] = count($userids);
                                                $trackname[] = $alltracks_values->name;
                                                $noof_course[] = count($countcourse);

                                             ?>
                                                <tr>
                                                   <td class="chart-hover" style="color:<?php
                                                                                          echo $colorarray[$y];
                                                                                          ?>;" title="<?php
                                                                                                      echo $alltracks_values->name;
                                                                                                      ?>"><?php
                                                                                       echo $alltracks_values->name;
                                                                                       ?></td>
                                                   <!-- <td><?php

                                                            // echo $alltracks_values->name;
                                                            ?></td> -->

                                                   <td><?php echo count($countcourse); ?></td>
                                                   <td><?php echo $count_of_category_enrolled_user; ?></td>
                                                </tr>

                                             <?php

                                                $y++;
                                             }

                                             $string_trackname = implode(",", $trackname);
                                             $string_count_of_user = implode(",", $count_of_user);
                                             $string_colorlist = implode(",", $colorarray);
                                             $string_courselist = implode(",", $noof_course);

                                             ?>
                                             <input type="hidden" id="countlist" value="<?php echo $string_count_of_user; ?>" />
                                             <input type="hidden" id="tracklist" value="<?php echo $string_trackname; ?>" />
                                             <input type="hidden" id="colorlist" value="<?php echo $string_colorlist; ?>" />
                                             <input type="hidden" id="coursecount" value="<?php echo $string_courselist; ?>" />

                                          </tbody>
                                       </table>
                                    </div>
                                 </div>
                              </section>

                           </div>
                        </div>
                     </div>
                  </section>
                  <section class="course-main">
                     <div class="d-flex gap-4">
                        <div class="course-section bg-grey-box">
                           <div class="status">
                              <div class="status-info">
                                 <h2 class="horizontal-line line3">Course Request</h2>
                                 <span><a href="instructor_courserequest.php"><i class="fa fa-share-square-o" title="view all"></i></a></span>
                              </div>
                              <div class="scrollable course-section-scroll">
                                 <table>
                                    <tr>
                                       <th>ID</th>
                                       <th>Course Name</th>
                                       <th>Track</th>
                                       <th>Status</th>
                                    </tr>
                                    <?php
                                    $draftedcoursescount = 1;
                                    foreach ($draftedcourses as $draftedcourse_value) {
                                       $trackname = $DB->get_record_sql("SELECT * FROM {course_categories} WHERE id = $draftedcourse_value->parent AND parent = 0");
                                       if ($DB->record_exists('request_subcategory', ['subcategory_id' => $draftedcourse_value->id, 'status' => 4])) {
                                          $status = 'To be Revised';
                                          $class = 'status-revised';
                                       }
                                       elseif ($DB->record_exists('request_subcategory', ['subcategory_id' => $draftedcourse_value->id, 'status' => 5])) {
                                          $status = 'Rejected';
                                          $class = 'status-red';
                                       }
                                       elseif ($DB->record_exists('request_subcategory', ['subcategory_id' => $draftedcourse_value->id, 'status' => 6])) {
                                          $status = 'Approved';
                                          $class = 'status-darkgreen';
                                       }
                                       else {
                                          $status = 'Pending for approval';
                                          $class = 'status-pending';
                                       }

                                    ?>
                                       <tr>
                                          <td><?php echo $draftedcoursescount; ?></td>
                                          <td><a href="courses.php?id=<?php echo $trackname->id; ?>"><?php echo $draftedcourse_value->name; ?></a></td>
                                          <td><?php echo $trackname->name; ?></td>
                                          <td class="<?php echo $class; ?>"><?php echo $status; ?></td>

                                       <?php
                                       $draftedcoursescount++;
                                    }
                                       ?>
                                       </tr>
                                 </table>
                              </div>

                           </div>
                        </div>
                     </div>
                  </section>

                  <section class="recent-activity">
                     <div class="d-flex gap-4">
                        <div class="recent-section bg-grey-box">
                           <div class="status">
                              <div class="status-info">
                                 <h2 class="horizontal-line line4">Notes</h2>
                                 <span><a href="all-notes-view.php"><i class="fa fa-share-square-o" title="view all"></i></a></span>
                              </div>
                              <textarea name="" id="" cols="67" rows="5" class="textarea py-2" placeholder="Enter Notes" ></textarea>
                              <button class="save-node">Save Note</button>
                              <span id="empty_error" style="color:red;"></span>
                              <div class="scrollable nodes">
                                 <div class="textarea-content">
                                    <h3 class="notes horizontal-line all-notes">All Notes</h3>

                                    <div class="ps-2 newnotes">
                                       <?php $i = 1; ?>
                                    <?php
                                    foreach ($notepaddata as $notepadata) {
                                    ?>
                                       <p class="mb-1 d-flex  justify-content-start"><b><?php echo $i++ ?>. &nbsp;&nbsp;</b> <span><?php echo $notepadata->note; ?></span></p>
                                    <?php } ?>
                                    </div>
                                 </div>
                              </div>
                           </div>
                        </div>
                        <div class="recent-section bg-grey-box">
                           <div class="status">
                              <div class="status-info">
                                 <h2 class="horizontal-line line5">Recent Activity</h2>
                                 <span><a href="allrecent_activity.php"><i class="fa fa-share-square-o" title="view all"></i></a></span>
                              </div>
                              <div class="activity-overflow">
                                 <?php
                                 foreach ($recent_badge_assigned as $recent_badge_assigned1) {
                                    if ($recent_badge_assigned1->type) {
                                       if ($recent_badge_assigned1->type == 'track') {
                                       $categorytype = 'Certificate';
                                     }
                                     else {
                                        
                                        $categorytype = 'Badge';
                                       }
                                     
                                 ?>
                                    <div class="activity">
                                       <div class="activity-icon"><i class="fa fa-user-o"></i></div>
                                       <div class="activity-detail">
                                       <p><?php echo $recent_badge_assigned1->student_firstname; ?> win <?php echo $categorytype." in ".$recent_badge_assigned1->course_name; ?></p>
                                       <span class="span"><?php echo date('d-m-Y h:i:s a',$recent_badge_assigned1->timecreated); ?></span>
                                       </div>
                                    </div>
                                 <?php
                                 }}
                                 ?>

                                 <?php
                                 foreach ($recent_certificate_assigned as $recent_certificate_assigned1) {
                                 ?>
                                    <div class="activity">
                                       <div class="activity-icon"><i class="fa fa-user-o"></i></div>
                                       <div class="activity-detail">
                                       <p><?php echo $recent_certificate_assigned1->student_firstname; ?> win certificate in <?php echo $recent_certificate_assigned1->track_name; ?></p>
                                          <span class="span"><?php echo date('d-m-Y h:i:s a',$recent_certificate_assigned1->timecreated); ?></span></div>
                                    </div>
                                 <?php
                                 }
                                 ?>

                              </div>
                           </div>
                        </div>
                     </div>
                  </section>
                  <section>
                     <div class="calendar-icon">
                        <i class="fa fa-calendar" aria-hidden="true"></i>

                     </div>
                  </section>
                  <section class="login Activity bg-grey-box">
                     <div class="status">
                        <div class="status-info">
                           <h2 class="horizontal-line line6">Login Activity</h2>
                          

                           <div class="d-flex">
                              <span>
                                 <!-- <div class="dropdown">
                                    <a class="p-0 m-0" type="button" data-toggle="dropdown" aria-expanded="false">
                                       <img src="../../pix/i/prgress-icon.png" alt="" class="prgress-icon">
                                    </a>
                                    <ul class="dropdown-menu dropdown-menu-right p-0 m-0">
                                      <li><a class="dropdown-item" href="#">Active</a></li>
                                      <div class="dropdown-divider m-0"></div>
                                      <li><a class="dropdown-item" href="#">InActive</a></li>
                                    </ul>
                                  </div> -->
                              </span>
                              <span>
                              <button class="btn btn-primary" id="bulklogout">Bulk Logout</button>   
                              <a href="alllogin_activity.php"><i class="fa fa-share-square-o" title="view all"></i></a></span>
                           </div>

                        </div>
                        <div class="scrollable activity-table">
                           <table>
                              <tr>
                                 <th>
                                    <!-- <div class="form-group"> -->
                                    <!-- <input type="checkbox" name="myCheckbox" id="myCheckbox">
                                    <label for="myCheckbox"> </label> -->
                                    <!-- </div> -->

                                    <!-- <label class="custom71"> -->
                                       <input type="checkbox"  disabled value=''>
                                       <!-- <span class="checkmark"></span> -->
                                     <!-- </label> -->

                                 </th>
                                 <th class="text-center">No</th>
                                 <th class="text-center">Date | Time</th>
                                 <th class="text-center">Location</th>
                                 <th class="text-center">IP Address</th>
                                 <th class="text-center">User Agent</th>
                                 <th class="text-center">Status</th>
                                 <th class="text-center">Action</th>
                              </tr>
                              <?php
                              $rowcount = 1;
                              foreach ($accessdata as $accessdata_value) {
                                 // if ($rowcount == 1) {
                                 //   //skip current login
                                 // }
                                 // else {


                                 $user_ip = $accessdata_value->ip;
                                 $json     = file_get_contents("http://ipinfo.io/$user_ip/geo");
                                 $json     = json_decode($json, true);
                                 //  $country  = $json['country'];
                                 //  $region   = $json['region'];
                                 $city     = $json['city'];
                                 if ($accessdata_value->browsername == "Chrome") {
                                    $filename = "chrome";
                                 }
                                 if ($accessdata_value->browsername == "Firefox") {
                                    $filename = "firefox";
                                 }
                                 if ($accessdata_value->browsername == "Microsoft" || $accessdata_value->browsername == "Edge") {
                                    $filename = "microsoft";
                                 }
                                 if ($accessdata_value->browsername == "Compass") {
                                    $filename = "compass";
                                 }
                                 if ($DB->record_exists('sessions', ['userid' => $USER->id, 'timecreated' => $accessdata_value->timecreated, 'firstip' => $accessdata_value->ip])) {
                                    $disable = '';
                                    $checkboxvalue =  $accessdata_value->timecreated."_".$accessdata_value->ip;
                                 }
                                 else {
                                    $disable = 'disabled';
                                    $checkboxvalue =  '';

                                 }
                              ?>
                                 <tr>
                                    <td>
                                      
                                       <!-- <label class="custom71">
                                          <input type="checkbox"  id="html5">
                                          <span class="checkmark"></span>
                                        </label> -->
                                        <input type="checkbox" class= 'checkbox' <?= $disable ?> value="<?= $checkboxvalue ?>">

                                    </td>
                                    <td><?php echo ($rowcount); ?></td>
                                    <td><?php echo date('d-m-Y h:i:s A', $accessdata_value->timecreated); ?></td>
                                    <td><?php echo $city; ?></td>
                                    <td><?php echo $user_ip; ?></td>
                                    <?php
                                    if ($accessdata_value->browsername) { ?>
                                       <td>
                                          <img src="images/<?php echo $filename; ?>.png" alt="chrome">
                                          <!-- <?php echo $accessdata_value->browsername; ?> -->
                                       </td>

                                    <?php
                                    } else { ?>
                                       <td></td>
                                    <?php

                                    }
                                    ?>
                                    <?php
                                    if ($DB->record_exists('sessions', ['userid' => $USER->id, 'timecreated' => $accessdata_value->timecreated, 'firstip' => $accessdata_value->ip])) {
                                    ?> <td>
                                       <div  class="active-green">Active</div>
                                       <td>
                                       <span onClick="javascript:return confirm('are you sure you want to delete this session?');">

                                          <a href="<?php echo $CFG->wwwroot . '/local/public/delete_session.php?timecreated=' . $accessdata_value->timecreated . '&ip=' . $accessdata_value->ip . '' ?>">
                                             <i class="fa fa-power-off" aria-hidden="true">
                                             </i>
                                          </a>
                                       </span>
                                    </td>
                                    </td>
                                    <?php  } else { ?>
                                       <td>
                                          <div class="active-cream">Inactive</div></td>
                                          <td>
                                       <span>

                                          <a href="#" style="pointer-events:none">
                                             <i class="fa fa-power-off" aria-hidden="true">
                                             </i>
                                          </a>
                                       </span>
                                    </td>
                                    <?php   }
                                    ?>


                                  
                                 </tr>
                              <?php

                                 // }
                                 $rowcount++;
                              }
                              ?>

                           </table>
                        </div>

                     </div>
                  </section>
                  <section class="course-main" id="Lab-Scenario-request">
                     <div class="d-flex gap-4">
                        <div class="lab-section bg-grey-box">
                           <div class="status">
                              <div class="status-info">
                                 <h2 class="horizontal-line labafterw">Lab/Scenario request</h2>
                                 <span><a href="#"><i class="fa fa-share-square-o" title="view all"></i></a></span>
                              </div>
                           </div>
                           <div class="table-overflow scrollable leaderboard-scroll-height">
                              <table class="leaderboard-table">
                                 <tbody>
                                    <tr>
                                       <th class="">Id</th>
                                       <th class="">Lab/Scenario Name</th>
                                       <th class="">Date/Time</th>
                                       <th class="">Action</th>
                                    </tr>
                                    <tr>
                                       <td></td>
                                       <td></td>
                                       <td></td>
                                       <td class="status-alot">Alot</td>
                                    </tr>
                                    <tr>
                                       <td></td>
                                       <td></td>
                                       <td></td>
                                       <td class="status-cancel">Cancel</td>
                                    </tr>
                                    <tr>
                                       <td></td>
                                       <td></td>
                                       <td></td>
                                       <td class="status-alot">Alot</td>
                                    </tr>
                                    <tr>
                                       <td></td>
                                       <td></td>
                                       <td></td>
                                       <td class="status-alot">Alot</td>
                                    </tr>
                                    <tr>
                                       <td></td>
                                       <td></td>
                                       <td></td>
                                       <td class="status-cancel">Cancel</td>
                                    </tr>
                                 </tbody>
                              </table>
                           </div>
                        </div>

                     </div>
                  </section>
                  <div class="fixed">
                     <div class="calendar-cross-icon"><a href="#"><i class="fa fa-times" aria-hidden="true"></i></a></div>
                     <div class="clock">
                        <div id="Date"></div>
                        <ul class="ull">
                           <li class="lii" id="hours"></li>
                           <li class="lii" id="point">:</li>
                           <li class="lii" id="min"></li>
                           <li class="lii" id="point">:</li>
                           <li class="lii" id="sec"></li>
                           <li class="lii" id="ampm"></li>
                        </ul>
                     </div>
                     <div id="calendar"></div>
                     <div class="calendar-btn"><a href="<?php echo $CFG->wwwroot . '/calendar/view.php?view=month'; ?>" class="create-event">Create Event</a></div>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </div>
   <!-- <script src="jquery/jquery.min.js"></script> -->
   <script src="chart/Chart.js"></script>
   <script src="amd/src/datepicker.min.js"></script>
</body>

</html>
<?php echo $OUTPUT->footer(); ?>